/***************************************************************************
 *   Copyright (C) 2005 by Joachim Friedrich                               *
 *   joachim.friedrich@biozentrum.uni-wuerzburg.de                         *
 *                                                                         *
 *   This file is part of profdist and cbcanalyzer                         *
 *                                                                         *
 *   Both profdist and cbcanalyzer are free software; you can redistribute * 
 *   it and/or modify it under the terms of the GNU General Public License * 
 *   as published by the Free Software Foundation; either version 2 of the * 
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   Profdist and cbcanalyzer are distributed in the hope that it will be  *
 *   useful, but WITHOUT ANY WARRANTY; without even the implied warranty   *
 *   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

//---------------------------------------------------------------------------
// tVector.h
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
// INCLUDES
//---------------------------------------------------------------------------
#include <string>
#include <vector>

//---------------------------------------------------------------------------
// DEFINES, MAKROS
//---------------------------------------------------------------------------
#ifndef tVector_H
  #define tVector_H
using namespace std;


//---------------------------------------------------------------------------
// CLASS DEFINITIONS
//---------------------------------------------------------------------------



template < class T >
class tVector 
{
public:
  //-------------------------------------------------------------------------
  // Constructors, Destructors
  //-------------------------------------------------------------------------
  tVector()
  {
    mSize = 0;
    mVec.resize( 0 );
  }

  tVector( long n )
  {
    mSize = n;
    mVec.resize( n );
  }

  tVector( vector < T > V )
  {
    mSize = V.size();
    mVec = V;
  };

  tVector( long n, vector < T > V )
  {
    mSize = n;
    mVec = V;
  }

  tVector( long n, T value )
  {
    mSize = n;
    for ( long i = 0; i < n; ++i )
      mVec.push_back( value );
  }

  tVector( long n, T * value )
  {
    mSize = n;
    for ( long i = 0; i < n; ++i )
      mVec.push_back( value[i] );
  }

  ~tVector()
  {
    mSize = 0;
    mVec.resize( 0 );
  }

  //-------------------------------------------------------------------------
  // Functions
  //-------------------------------------------------------------------------
  tVector( const tVector < T > & V ) // copy
  {
    mSize = V.mSize;
    mVec = V.mVec;
  }

  tVector < T > & operator = ( const tVector < T > & V ) // assign
  {
    mSize = V.mSize;
    mVec = V.mVec;
    return * this;
  }

  long nSize()
  {
    return mSize;
  }

  long resize( long n )
  {
    mSize = n;
    mVec.resize( n );
    return n;
  }

  //-------------------------------------------------------------------------
  // Operators
  //-------------------------------------------------------------------------
  T & operator() ( long i )
  {
    return mVec[i];
  }

  friend ostream & operator << ( ostream & s, tVector < T > & V )
  {
    cout << V.nsize() << endl;
    for ( int i = 1; i <= V.nsize(); ++i )
      s << V( i ) << endl;

    return s;
  }

protected:
  vector < T > mVec; // vector of T
  long mSize; // number of elements
};


#endif // tVector_H
