/***************************************************************************
 *   Copyright (C) 2005 by Andreas Pokorny                                 *
 *   andreas.pokorny@biozentrum.uni-wuerzburg.de                           *
 *                                                                         *
 *   This file is part of profdist and cbcanalyzer                         *
 *                                                                         *
 *   Both profdist and cbcanalyzer are free software; you can redistribute * 
 *   it and/or modify it under the terms of the GNU General Public License * 
 *   as published by the Free Software Foundation; either version 2 of the * 
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   Profdist and cbcanalyzer are distributed in the hope that it will be  *
 *   useful, but WITHOUT ANY WARRANTY; without even the implied warranty   *
 *   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef PAIR_ITERATOR_H_INCLUDED
#define PAIR_ITERATOR_H_INCLUDED

#include <boost/iterator/iterator_facade.hpp>

template<typename ValueType, typename Iterator1, typename Iterator2>
struct pair_iterator : public boost::iterator_facade<pair_iterator<ValueType,Iterator1,Iterator2>,ValueType, boost::bidirectional_traversal_tag > 
{
  Iterator1 it1_;
  Iterator2 it2_;
  pair_iterator( Iterator1 const& ref1, Iterator2 const& ref2 ) 
    : it1_(ref1), it2_(ref2) { }
  inline ValueType& dereference() const { return *it1_; }
  inline bool equal( pair_iterator<ValueType,Iterator1,Iterator2> const& y ) const { return it1_ == y.it1_; }
  inline void increment()
  {
    ++it1_;
    ++it2_;
  }
  inline void decrement()
  {
    --it1_;
    --it2_;
  }

  Iterator1 const& first() const { return it1_; }
  Iterator2 const& second() const { return it2_; }
};

#endif

