#include "memory_resource.hpp"
#include <cstring>
#include <iostream>

MemoryResource::MemoryResource(const char* data)
: _data(0), _size(0)
{
	if(data)
	{
		size_t size = std::strlen(data);
		_data = new char[size];
		std::copy(data, data + size, _data);
		_size = size;
	}
}

/*
MemoryResource::MemoryResource(const std::string& fileName)
: _data(0), _size(0)
{
	std::ifstream in(fileName.c_str());
	if(in)
	{
		in.seekg(0, std::ios_base::end);
		size_t size =in.tellg();
		in.seekg(0, std::ios_base::beg);
		_data = new char[size];
		in.read(_data, _size);
		if(!in.fail())
		{
            _size = size;
		}
		else
		{
			delete [] _data;
			_size = 0;
		}
	}
}
*/

MemoryResource::~MemoryResource()
{
	if(_data)
	{
		delete [] _data;
		_size = 0;
	}
}

const char* MemoryResource::begin() const
{
	return _data;
}

const char* MemoryResource::end() const
{
	return _data + _size;
}

size_t MemoryResource::size() const
{
	return _size;
}
