/***************************************************************************
 *   Copyright (C) 2005 by Andreas Pokorny                                 *
 *   andreas.pokorny@biozentrum.uni-wuerzburg.de                           *
 *                                                                         *
 *   This file is part of profdist and cbcanalyzer                         *
 *                                                                         *
 *   Both profdist and cbcanalyzer are free software; you can redistribute * 
 *   it and/or modify it under the terms of the GNU General Public License * 
 *   as published by the Free Software Foundation; either version 2 of the * 
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   Profdist and cbcanalyzer are distributed in the hope that it will be  *
 *   useful, but WITHOUT ANY WARRANTY; without even the implied warranty   *
 *   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "aligncode.h"
using namespace std;



//--------------------- Well-formed and fixed Debug output -----------------------------------------------

ostream & operator<<( ostream & out, AlignCode const& obj )
{
  out << "ALIGNCODE: " << obj.get_num_sequences() << " SEQ " << obj.get_num_sites() << " SITES\n";
  for( size_t i = 0; i < obj.get_num_sequences(); ++i )
  {
    out << i << ":" << obj.get_sequence_name( i ) << ":";
    for( AlignCode::const_sequence_iterator it = obj.begin(i),
        e = obj.end(i); it != e; ++it )
       out << obj.mapper.code2dna[*it];
    out << '\n';
  }
  return out;
}




#include "parser.h"
void parse_file( AlignCode & obj, std::string const& filename, profdist::FileType t )
{
  std::list<file_sequence> sequences; 
  switch( t) 
  {
    case profdist::Fasta:
      parse_fasta( filename, sequences );
      break;
    case profdist::Embl:
      parse_embl( filename, sequences );
      break;
  }

  obj.read_sequences( sequences );
}

std::ostream& write_file( AlignCode & obj, std::ostream& file, profdist::FileType t )
{
  switch( t) 
  {
    case profdist::Fasta:
      {
        for( size_t i = 0; i < obj.get_num_sequences(); ++i )
        {
          file << ">" << obj.get_sequence_name( i ) << "\n";
          for( AlignCode::const_sequence_iterator it = obj.begin(i),
              e = obj.end(i); it != e; ++it )
            file << obj.mapper.code2dna[*it];
          file << '\n';
        }
        return file;
      }
    case profdist::Embl:
      {
        for( size_t i = 0; i < obj.get_num_sequences(); ++i )
        {
          file << "ID " << obj.get_sequence_name( i ) << "\n";
          file << "SQ Sequence "  << obj.get_num_sites() << " BP;";
          
          size_t site_index = 0;
          for( AlignCode::const_sequence_iterator it = obj.begin(i),
              e = obj.end(i); it != e; ++it, ++site_index )
          {
            if( site_index%60== 0 ) file << "    ";
            else if( site_index%6== 0 ) file << ' ';
            file << obj.mapper.code2dna[*it];
          }
          if( site_index%60 ) file << '\n';
          file << "\\\\\n";
        }
        return file;
      }
  }
}

