#include <QSettings>
#include <QRadioButton>
#include <QFileDialog>
#include <QButtonGroup>
#include "preferences_dialog.hpp"

PreferencesDialog::PreferencesDialog()
{
	setupUi(this);
	QButtonGroup* group = new QButtonGroup(this);
	group->addButton(radioButton_0, 0);
	group->addButton(radioButton_1, 1);
	group->addButton(radioButton_2, 2);
	
	connect(buttonBox, SIGNAL(accepted()), this, SLOT(onOk()));
	connect(openFile1, SIGNAL(clicked()), this, SLOT(open1()));
	connect(openFile2, SIGNAL(clicked()), this, SLOT(open2()));
	
	QSettings settings;
	lineEditTreeViewer1->setText(settings.value("tree_viewer_1").toString());
	lineEditTreeViewer2->setText(settings.value("tree_viewer_2").toString());
	int selected = settings.value("selected_tree_viewer").toInt();
    int checkState = settings.value("multiple_instances").toInt();
	if(selected < 0)
		selected = 0;
	
	QAbstractButton* button = group->button(selected);
	button->setChecked(true);
    if(checkState) checkBox->setCheckState(Qt::Checked);
}

void PreferencesDialog::onOk()
{
	QSettings settings;
	settings.setValue("tree_viewer_1", lineEditTreeViewer1->text());
	settings.setValue("tree_viewer_2", lineEditTreeViewer2->text());
	settings.setValue("selected_tree_viewer", radioButton_0->group()->checkedId());
    settings.setValue("multiple_instances", checkBox->checkState());
	accept();
}

void PreferencesDialog::open1()
{
	QString fileName = QFileDialog::getOpenFileName(this, tr("Select tree viewer executable"));
	
	if(fileName.isNull())
		return;
	
	lineEditTreeViewer1->setText(fileName);
}

void PreferencesDialog::open2()
{
	QString fileName = QFileDialog::getOpenFileName(this, tr("Select tree viewer executable"));
	
	if(fileName.isNull())
		return;
	
	lineEditTreeViewer2->setText(fileName);
}


