#ifndef CBC_ANALYZER_MAIN_WINDOW_HPP_
#define CBC_ANALYZER_MAIN_WINDOW_HPP_

#include <QMainWindow>
#include <QTemporaryFile>
#include "ui_main_window.h"

class MainWindow : public QMainWindow, public Ui::MainWindow
{
		Q_OBJECT
	public:
		MainWindow();
		void startTreeViewer(const QString& fileName);
		
	public Q_SLOTS:
		void open();
		void saveAs();
		void preferences();
        QString prepareTmpFile(QTemporaryFile& file, const QString& str);
		void showTree();
		void run();
		void about();
		void help();
		
	private Q_SLOTS:
		void setInputsEditable(bool editable);
		void tabChanged(int index);
		void openLink(const QString& link);
		
	private:
		
		enum {
			CT_TRANSFORM = 0,
			CBC_DETECT = 1,
			CBC_TREE = 2
		};
		
		bool runTransform();
		bool runDetect();
		bool runTree();
		
		bool newCbcDetectOutput;
		
		// explicitly stores the normal detected output matrix
		std::string cbc_detect_matrix;
		
		// explicitly stores the normal plus half cbcs matrix
		std::string cbc_plus_half_detect_matrix;
		
		std::string cbc_tree;
		std::string cbc_plus_half_tree;
		
		QTemporaryFile tmpFile1;
		QTemporaryFile tmpFile2;
        QTemporaryFile tmpFile3;
};

#endif // CBC_ANALYZER_MAIN_WINDOW_HPP_
