/***************************************************************************
 *   Copyright (C) 2005 by Joachim Friedrich                               *
 *   joachim.friedrich@biozentrum.uni-wuerzburg.de                         *
 *                                                                         *
 *   This file is part of profdist and cbcanalyzer                         *
 *                                                                         *
 *   Both profdist and cbcanalyzer are free software; you can redistribute * 
 *   it and/or modify it under the terms of the GNU General Public License * 
 *   as published by the Free Software Foundation; either version 2 of the * 
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   Profdist and cbcanalyzer are distributed in the hope that it will be  *
 *   useful, but WITHOUT ANY WARRANTY; without even the implied warranty   *
 *   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "cbcAnalyser.h"

void MyDialogPref::onBtnPrefOk( wxCommandEvent & WXUNUSED( event ) )
{
  ( * this ).EndModal( idBtnPrefOk );
}


void MyDialogPref::onBtnPrefCancel( wxCommandEvent & WXUNUSED( event ) )
{
  ( * this ).EndModal( idBtnPrefCancel );
}


void MyDialogPref::onBtnPrefHelp( wxCommandEvent & WXUNUSED( event ) )
{
  help.Display( wxT( "cbcAnalyzer Helpfile" ) );
}

void MyDialogPref::onRdoTree1( wxCommandEvent & WXUNUSED( event ) )
{
  mPrefTreeType = 0;
}

void MyDialogPref::onRdoTree2( wxCommandEvent & WXUNUSED( event ) )
{
  mPrefTreeType = 1;
}

void MyDialogPref::onRdoPrefHypertree( wxCommandEvent & WXUNUSED( event ) )
{
  mPrefTreeType = 2;
}

void MyDialogPref::onRdoPrefNone( wxCommandEvent & WXUNUSED( event ) )
{
  mPrefTreeType = 3;
}


void MyDialogPref::onBtnPrefOpenTreeViewer1( wxCommandEvent & WXUNUSED( event ) )
{
  wxFileDialog dialog( this, _T( "Open Dialog" ), _T( "" ), _T( "" ),
#ifdef __WXMSW__
  _T( "Executables (*.exe)|*.exe" )
#else
  _T( "All files (*)|*" )
#endif
  );

  if ( dialog.ShowModal() == wxID_OK )
    txtPrefTreeViewer1->SetValue( dialog.GetPath() );
}


void MyDialogPref::onBtnPrefOpenTreeViewer2( wxCommandEvent & WXUNUSED( event ) )
{
  wxFileDialog dialog( this, _T( "Open Dialog" ), _T( "" ), _T( "" ),
#ifdef __WXMSW__
  _T( "Executables (*.exe)|*.exe" )
#else
  _T( "All files (*)|*" )
#endif
  );

  if ( dialog.ShowModal() == wxID_OK )
    txtPrefTreeViewer2->SetValue( dialog.GetPath() );
}

void MyDialogPref::onBtnPrefOpenBrowser( wxCommandEvent & WXUNUSED( event ) )
{
#if defined(UNIX_SYSTEM) || defined(DARWIN_SYSTEM)
  wxFileDialog dialog( this, _T( "Open Dialog" ), _T( "" ), _T( "" ),
#ifdef __WXMSW__
  _T( "Executables (*.exe)|*.exe" )
#else
  _T( "All files (*)|*" )
#endif
  );

  if ( dialog.ShowModal() == wxID_OK )
    txtPrefBrowser->SetValue( dialog.GetPath() );
#endif
}

#if defined(UNIX_SYSTEM) || defined(DARWIN_SYSTEM)
void MyDialogPref::setPreferences( long & evoModel, long & treeViewType, wxString & treeView1, wxString & treeView2, wxString & browser)
#else 
void MyDialogPref::setPreferences( long & evoModel, long & treeViewType, wxString & treeView1, wxString & treeView2 )
#endif
{
  //rdoPrefEvolution->SetSelection( evoModel );

  if ( treeViewType == 0 )
    rdoTree1->SetValue( true );
  else if ( int( treeViewType ) == 1 )
    rdoTree2->SetValue( true );
  else
    rdoPrefNoneTree->SetValue( true );

  mPrefTreeType = treeViewType;
  txtPrefTreeViewer1->SetValue( treeView1 );
  txtPrefTreeViewer2->SetValue( treeView2 );
#if defined(UNIX_SYSTEM) || defined(DARWIN_SYSTEM)
  txtPrefBrowser->SetValue( browser );
#endif
}
#if defined(UNIX_SYSTEM) || defined(DARWIN_SYSTEM)
void MyDialogPref::getPreferences( long & evoModel, long & treeViewType, wxString & treeView1, wxString & treeView2, wxString & browser)
#else
void MyDialogPref::getPreferences( long & evoModel, long & treeViewType, wxString & treeView1, wxString & treeView2 )
#endif
{
  //evoModel = rdoPrefEvolution->GetSelection();

  treeViewType = mPrefTreeType;
  treeView1 = txtPrefTreeViewer1->GetValue();
  treeView2 = txtPrefTreeViewer2->GetValue();
#if defined(UNIX_SYSTEM) || defined(DARWIN_SYSTEM)
  browser = txtPrefBrowser->GetValue();
#endif
}

