/***************************************************************************
 *   Copyright (C) 2005 by Andreas Pokorny                                 *
 *   Andreas.pokorny@biozentrum.uni-wuerzburg.de                           *
 *                                                                         *
 *   This file is part of profdist and cbcanalyzer                         *
 *                                                                         *
 *   Both profdist and cbcanalyzer are free software; you can redistribute * 
 *   it and/or modify it under the terms of the GNU General Public License * 
 *   as published by the Free Software Foundation; either version 2 of the * 
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   Profdist and cbcanalyzer are distributed in the hope that it will be  *
 *   useful, but WITHOUT ANY WARRANTY; without even the implied warranty   *
 *   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "temp_files.h"

TempFile::TempFile( wxString const& tf )
  : file_name( wxFileName::CreateTempFileName( tf ) )
{ }

TempFile::~TempFile()
{
  if ( !item.file_queue.empty() )
  {
    ::wxRemoveFile( item.file_queue.front() );
    item.file_queue.pop();
  }

  item.file_queue.push( file_name );
}

TempFile::LastItem::~LastItem()
{
  while( !file_queue.empty() )
  {
    ::wxRemoveFile( file_queue.front() );
    file_queue.pop();
  }

}

TempFile::LastItem TempFile::item;

