/***************************************************************************
 *   Copyright (C) 2005 by Andreas Pokorny                                 *
 *   andreas.pokorny@biozentrum.uni-wuerzburg.de                           *
 *                                                                         *
 *   This file is part of profdist and cbcanalyzer                         *
 *                                                                         *
 *   Both profdist and cbcanalyzer are free software; you can redistribute * 
 *   it and/or modify it under the terms of the GNU General Public License * 
 *   as published by the Free Software Foundation; either version 2 of the * 
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   Profdist and cbcanalyzer are distributed in the hope that it will be  *
 *   useful, but WITHOUT ANY WARRANTY; without even the implied warranty   *
 *   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef PROFDIST_TYPES_H_INCLUDED
#define PROFDIST_TYPES_H_INCLUDED

#include "fixed_matrix.h" 
namespace profdist {
enum CorrectionModel
{
  Jukes,
  Kimura,
  GTR,
  LogDet
};


enum ExpMType
{
  Pade, 
  Taylor
};

enum FZero
{
  Derivation,
  NewtonMethod,
  Robust,
  Parabolic
};

enum FileType
{
  Fasta, Embl
};

typedef fixed_matrix<size_t,16,16>  count_matrix;
typedef fixed_matrix<double,4,4> small_float_count_matrix;
typedef fixed_matrix<double,4,4> rate_matrix;


}
#include "tMatrix.h"  // replace with boost::ublas asap after release
#include "fixed_matrix_math.h" 
namespace profdist {
typedef tMatrix<double> distance_matrix;
}
#endif 
