/***************************************************************************
 *   Copyright (C) 2005 by Andreas Pokorny                                 *
 *   andreas.pokorny@biozentrum.uni-wuerzburg.de                           *
 *                                                                         *
 *   This file is part of profdist and cbcanalyzer                         *
 *                                                                         *
 *   Both profdist and cbcanalyzer are free software; you can redistribute * 
 *   it and/or modify it under the terms of the GNU General Public License * 
 *   as published by the Free Software Foundation; either version 2 of the * 
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   Profdist and cbcanalyzer are distributed in the hope that it will be  *
 *   useful, but WITHOUT ANY WARRANTY; without even the implied warranty   *
 *   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef PROFDIST_LIB_RAI_ADAPTER_H_INCLUDED
#define PROFDIST_LIB_RAI_ADAPTER_H_INCLUDED
#include <boost/iterator/iterator_adaptor.hpp>
#include <algorithm>

template<typename IteratorT>
struct RAIAdaptor  : public boost::iterator_adaptor<RAIAdaptor<IteratorT>, IteratorT,boost::use_default, std::random_access_iterator_tag> {
  typedef boost::iterator_adaptor<RAIAdaptor<IteratorT>, IteratorT,boost::use_default, std::random_access_iterator_tag> base_type;
  RAIAdaptor( ) {}
  explicit RAIAdaptor( IteratorT const& it) 
    :  base_type(it)  {}
  void advance( typename base_type::difference_type n) { if( n > 0 ) while(n--) --(this->base_reference()); else while(n++ != 0) ++(this->base_reference()); }
  typename base_type::difference_type  distance_to( RAIAdaptor<IteratorT> const& j ) const 
  { return std::distance( this->base(), j.base() ); }
};

#endif
