/***************************************************************************
 *   Copyright (C) 2005 by Andreas Pokorny                                 *
 *   andreas.pokorny@biozentrum.uni-wuerzburg.de                           *
 *                                                                         *
 *   This file is part of profdist and cbcanalyzer                         *
 *                                                                         *
 *   Both profdist and cbcanalyzer are free software  you can redistribute * 
 *   it and/or modify it under the terms of the GNU General Public License * 
 *   as published by the Free Software Foundation  either version 2 of the * 
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   Profdist and cbcanalyzer are distributed in the hope that it will be  *
 *   useful, but WITHOUT ANY WARRANTY  without even the implied warranty   *
 *   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program  if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "wx_streambuf.h"


wx_streambuf::wx_streambuf( wxTextCtrl & r )
  : ref(r)
{
  setp(array, array + sizeof(array) - 1 );
  setg(0,0,0);
}

int wx_streambuf::overflow( int c )
{
  sync();

  if(c != EOF)
    if(pbase() == epptr())
      ref << char(c);
    else
      sputc(c);

  return 0;
}

int wx_streambuf::sync( )
{
  std::size_t num = pptr() - pbase();

  if( num != 0 )
  {
    array[num] = 0;
    ref.AppendText( wxString(array, num ) );

    setp(pbase(), epptr());
  }
  return 0;
}

wx_streambuf::~wx_streambuf()
{
  sync();
}


