/***************************************************************************
 *   Copyright (C) 2005 by Andreas Pokorny                                 *
 *   andreas.pokorny@biozentrum.uni-wuerzburg.de                           *
 *                                                                         *
 *   This file is part of profdist and cbcanalyzer                         *
 *                                                                         *
 *   Both profdist and cbcanalyzer are free software  you can redistribute * 
 *   it and/or modify it under the terms of the GNU General Public License * 
 *   as published by the Free Software Foundation  either version 2 of the * 
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   Profdist and cbcanalyzer are distributed in the hope that it will be  *
 *   useful, but WITHOUT ANY WARRANTY  without even the implied warranty   *
 *   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program  if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "wx_colorbuf.h"


wx_colour_streambuf::wx_colour_streambuf( wxTextCtrl & r )
  : ref(r)
{
  setp(array, array + sizeof(array) - 1 );
  setg(0,0,0);
}

namespace hidden {
  enum state{ open, close, nothing };
  inline state get_state( char c ) { return c=='('?hidden::open:c==')'?hidden::close:hidden::nothing; }
  inline void set_style( wxTextCtrl & ref, state c ) 
  { switch(c) 
    {
      case hidden::open:   ref.SetDefaultStyle(wxTextAttr(*wxWHITE, *wxRED) );  break;
      case hidden::close:    ref.SetDefaultStyle(wxTextAttr(*wxWHITE, *wxBLUE) ); break;
      case hidden::nothing:    ref.SetDefaultStyle(wxTextAttr(*wxBLACK, *wxWHITE) ); break;
    };
  }
}


int wx_colour_streambuf::overflow( int c )
{
  sync();

  if(c != EOF)
    if(pbase() == epptr())
    {
      hidden::set_style( ref, hidden::get_state( c ) );
      ref << char(c);
    }
    else
      sputc(c);

  return 0;
}

int wx_colour_streambuf::sync( )
{
  std::size_t num = pptr() - pbase();

  if( num != 0 )
  {
    array[num] = 0;
   
    hidden::state current = hidden::get_state(array[0]);
    std::size_t start_pos = 0; 
    for( std::size_t i = 1; i < num; ++i )
    {
      hidden::state n_state = hidden::get_state(array[i] );
      if( current != n_state )
      {
        char temp = array[i];
        array[i]=0;
        hidden::set_style( ref, current );
        ref.AppendText( wxString(array+start_pos, i - start_pos ) );
        array[i]=temp;
        start_pos = i;
        current = n_state;
      }
    }
    hidden::set_style( ref, current );
    ref.AppendText( wxString( array+start_pos, num + start_pos ) );

    setp(pbase(), epptr());
  }
  return 0;
}

wx_colour_streambuf::~wx_colour_streambuf()
{
  sync();
}


