/***************************************************************************
 *   Copyright (C) 2005 by Joachim Friedrich                               *
 *   joachim.friedrich@biozentrum.uni-wuerzburg.de                         *
 *                                                                         *
 *   This file is part of profdist and cbcanalyzer                         *
 *                                                                         *
 *   Both profdist and cbcanalyzer are free software; you can redistribute * 
 *   it and/or modify it under the terms of the GNU General Public License * 
 *   as published by the Free Software Foundation; either version 2 of the * 
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   Profdist and cbcanalyzer are distributed in the hope that it will be  *
 *   useful, but WITHOUT ANY WARRANTY; without even the implied warranty   *
 *   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

// -*- C++ -*- generated by wxGlade 0.3.2 on Tue Jul 06 19:02:41 2004
#include <cstdlib>
#include <exception>
#include <fstream>
#include <sstream>
#include <cstdio>
#include <boost/version.hpp>
#include <ctime>
#include "cbcAnalyser.h"
#include "wxEvent.h"
#include <wx/msgdlg.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifndef WINDOWS_SYSTEM
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <fcntl.h>
#endif 

#ifdef DARWIN_SYSTEM
#include <Carbon/Carbon.h>
#endif


MyFrame::MyFrame( wxWindow * parent, int id, const wxString & title, const wxPoint & pos, const wxSize & size, long style ) :
  wxFrame( parent, id, title, pos, size, wxDEFAULT_FRAME_STYLE )
{

  help.UseConfig( wxConfig::Get() );
  bool ret;
#ifndef DARWIN_SYSTEM
  help.SetTempDir( wxT( "." ) ); // wxT ??
  ret = help.AddBook( wxFileName( wxString( (MyApp::get_help_path() + "/help.hhp").c_str() ), wxPATH_UNIX ) );
  if ( !ret )
    wxMessageBox( wxString( ("Failed adding book " +  MyApp::get_help_path() +  "/help.hhp").c_str() ) );
#endif

  // Set up toolbar
  wxBitmap toolBarBitmaps[11];
  toolBarBitmaps[0] = wxBitmap( open_xpm );
  toolBarBitmaps[1] = wxBitmap( save_xpm );
  toolBarBitmaps[2] = wxBitmap( redo_xpm );
  toolBarBitmaps[3] = wxBitmap( undo_xpm );
  toolBarBitmaps[4] = wxBitmap( copy_xpm );
  toolBarBitmaps[5] = wxBitmap( cut_xpm );
  toolBarBitmaps[6] = wxBitmap( paste_xpm );
  toolBarBitmaps[7] = wxBitmap( run_xpm );
  toolBarBitmaps[8] = wxBitmap( tree_xpm );
  toolBarBitmaps[9] = wxBitmap( pref_xpm );
  toolBarBitmaps[10] = wxBitmap( help_xpm );

  // begin wxGlade: MyFrame::MyFrame
  ntbAll = new wxNotebook(this, idNotebook, wxDefaultPosition, wxDefaultSize, 0);
  ntbTree = new wxPanel(ntbAll, -1);
  ntbDetect = new wxPanel(ntbAll, -1);
  ntbTrans = new wxScrolledWindow(ntbAll, -1, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL);
  frame_1_menubar = new wxMenuBar();
  SetMenuBar(frame_1_menubar);
  wxMenu* wxglade_tmp_menu_1 = new wxMenu();
  wxglade_tmp_menu_1->Append(idMnuOpen, _("Open File...\tCtrl-O"), wxT(""), wxITEM_NORMAL);
  wxglade_tmp_menu_1->Append(idMnuSave, _("Save\tCtrl-S"), wxT(""), wxITEM_NORMAL);
  wxglade_tmp_menu_1->AppendSeparator();
  wxglade_tmp_menu_1->Append(idMnuExit, _("Exit\tAlt-X"), wxT(""), wxITEM_NORMAL);
  frame_1_menubar->Append(wxglade_tmp_menu_1, _("File"));
  wxMenu* wxglade_tmp_menu_2 = new wxMenu();
  wxglade_tmp_menu_2->Append(idMnuUndo, _("Undo\tCtrl-Z"), wxT(""), wxITEM_NORMAL);
  wxglade_tmp_menu_2->AppendSeparator();
  wxglade_tmp_menu_2->Append(idMnuCopy, _("Copy\tCtrl-C"), wxT(""), wxITEM_NORMAL);
  wxglade_tmp_menu_2->Append(idMnuCut, _("Cut\tCtrl-X"), wxT(""), wxITEM_NORMAL);
  wxglade_tmp_menu_2->Append(idMnuPaste, _("Paste\tCtrl-V"), wxT(""), wxITEM_NORMAL);
  wxglade_tmp_menu_2->AppendSeparator();
  wxglade_tmp_menu_2->Append(idMnuSelectAll, _("Select &All\tCtrl-A"), wxT(""), wxITEM_NORMAL);
  wxglade_tmp_menu_2->AppendSeparator();
  wxglade_tmp_menu_2->Append(idMnuPref, _("Preferences..."), wxT(""), wxITEM_NORMAL);
  frame_1_menubar->Append(wxglade_tmp_menu_2, _("Edit"));
  wxMenu* wxglade_tmp_menu_3 = new wxMenu();
  wxglade_tmp_menu_3->Append(idMnuStart, _("Start..\tCtrl-R"), wxT(""), wxITEM_NORMAL);
  wxglade_tmp_menu_3->Append(idMnuTree, _("Tree View\tCtrl-T"), wxT(""), wxITEM_NORMAL);
  frame_1_menubar->Append(wxglade_tmp_menu_3, _("Functions"));
  wxMenu* wxglade_tmp_menu_4 = new wxMenu();
  wxglade_tmp_menu_4->Append(idMnuHelp, _("cbcAnalyzer Help"), wxT(""), wxITEM_NORMAL);
  wxglade_tmp_menu_4->AppendSeparator();
  wxglade_tmp_menu_4->Append(idMnuAbout, _("About..."), wxT(""), wxITEM_NORMAL);

#ifndef DARWIN_SYSTEM
  frame_1_menubar->Append(wxglade_tmp_menu_4, _("Help"));
#endif
  frame_1_statusbar = CreateStatusBar(1, 0);
  frame_toolbar = new wxToolBar(this, -1, wxDefaultPosition, wxDefaultSize, wxTB_HORIZONTAL|wxTB_FLAT);
  SetToolBar(frame_toolbar);
  frame_toolbar->SetToolBitmapSize(wxSize(16, 16));
  frame_toolbar->AddTool(idMnuOpen, _("Open File..."), (toolBarBitmaps[0]), wxNullBitmap, wxITEM_NORMAL, _("Open File..."), wxT(""));
  frame_toolbar->AddTool(idMnuSave, _("Save"), (toolBarBitmaps[1]), wxNullBitmap, wxITEM_NORMAL, _("Save"), wxT(""));
  frame_toolbar->AddSeparator();
  frame_toolbar->AddTool(idMnuUndo, _("Undo"), (toolBarBitmaps[3]), wxNullBitmap, wxITEM_NORMAL, _("Undo"), wxT(""));
  frame_toolbar->AddSeparator();
  frame_toolbar->AddTool(idMnuCopy, _("Copy"), (toolBarBitmaps[4]), wxNullBitmap, wxITEM_NORMAL, _("Copy"), wxT(""));
  frame_toolbar->AddTool(idMnuCut, _("Cut"), (toolBarBitmaps[5]), wxNullBitmap, wxITEM_NORMAL, _("Cut"), wxT(""));
  frame_toolbar->AddTool(idMnuPaste, _("Paste"), (toolBarBitmaps[6]), wxNullBitmap, wxITEM_NORMAL, _("Paste"), wxT(""));
  frame_toolbar->AddSeparator();
  frame_toolbar->AddTool(idMnuStart, _("Start"), (toolBarBitmaps[7]), wxNullBitmap, wxITEM_NORMAL, _("Start..."), wxT(""));
  frame_toolbar->AddTool(idMnuTree, _("ViewTree"), (toolBarBitmaps[8]), wxNullBitmap, wxITEM_NORMAL, _("Tree Preview"), wxT(""));
  frame_toolbar->AddSeparator();
  frame_toolbar->AddTool(idMnuPref, _("Preferences"), (toolBarBitmaps[9]), wxNullBitmap, wxITEM_NORMAL, _("Preferences"), wxT(""));
#ifndef DARWIN_SYSTEM
  frame_toolbar->AddSeparator();
  frame_toolbar->AddTool(idMnuHelp, _("Help"), (toolBarBitmaps[10]), wxNullBitmap, wxITEM_NORMAL, _("Help"), wxT(""));
#endif
  frame_toolbar->Realize();
  txtTransInput = new wxTextCtrl(ntbTrans, -1, wxT(""), wxDefaultPosition, wxDefaultSize, wxTE_DONTWRAP|wxTE_RICH2|wxTE_MULTILINE|wxHSCROLL);
  txtTransOutput = new wxTextCtrl(ntbTrans, -1, wxT(""), wxDefaultPosition, wxDefaultSize, wxTE_DONTWRAP|wxTE_RICH2|wxTE_MULTILINE|wxHSCROLL);
  mHyperMarna = new wxHyperlinksCtrl(ntbTrans, idLinkMarna, "MARNA", wxPoint(70,30), wxDefaultSize, 0, "statictextlink2", "http://www.bio.inf.uni-jena.de/Software/MARNA/");
  mHyperRNA = new wxHyperlinksCtrl(ntbTrans, idLinkRNA, "RNA Forester", wxPoint(70,30), wxDefaultSize, 0, "statictextlink2", "http://bibiserv.techfak.uni-bielefeld.de/rnaforester/submission.html");
  txtDetectInput = new wxTextCtrl(ntbDetect, -1, wxT(""), wxDefaultPosition, wxDefaultSize, wxTE_DONTWRAP|wxTE_MULTILINE|wxHSCROLL);
  txtDetectOutput = new wxTextCtrl(ntbDetect, -1, wxT(""), wxDefaultPosition, wxDefaultSize, wxTE_DONTWRAP|wxTE_MULTILINE|wxHSCROLL);
  txtTreeInput = new wxTextCtrl(ntbTree, -1, wxT(""), wxDefaultPosition, wxDefaultSize, wxTE_DONTWRAP|wxTE_MULTILINE|wxHSCROLL);
  txtTreeOutput = new wxTextCtrl(ntbTree, -1, wxT(""), wxDefaultPosition, wxDefaultSize, wxTE_MULTILINE|wxHSCROLL);

  set_properties();
  do_layout();
  // end wxGlade
}


void MyFrame::set_properties()
{
  // Set up toolbar
  wxBitmap toolBarBitmaps[1];
  toolBarBitmaps[0] = wxBitmap( starlight_xpm );

  wxIcon _icon;
  _icon.CopyFromBitmap( toolBarBitmaps[0] );
  SetIcon( _icon );

  // begin wxGlade: MyFrame::set_properties
  SetTitle(_("cbcAnalyzer"));
  SetSize(wxSize(702, 581));
  int frame_1_statusbar_widths[] = { -1 };
  frame_1_statusbar->SetStatusWidths(1, frame_1_statusbar_widths);
  const wxString frame_1_statusbar_fields[] = {
    _("CBC Analyzer")
  };
  for(int i = 0; i < frame_1_statusbar->GetFieldsCount(); ++i) {
    frame_1_statusbar->SetStatusText(frame_1_statusbar_fields[i], i);
  }
  txtTransInput->SetFont(wxFont(9, wxMODERN, wxNORMAL, wxNORMAL, 0, "Courier New"));
  txtTransOutput->SetFont(wxFont(9, wxMODERN, wxNORMAL, wxNORMAL, 0, "Courier New"));
  ntbTrans->SetScrollRate(10, 10);
  txtDetectInput->SetFont(wxFont(9, wxMODERN, wxNORMAL, wxNORMAL, 0, ""));
  txtDetectOutput->SetFont(wxFont(9, wxMODERN, wxNORMAL, wxNORMAL, 0, ""));
  txtTreeInput->SetFont(wxFont(9, wxMODERN, wxNORMAL, wxNORMAL, 0, ""));
  txtTreeOutput->SetFont(wxFont(9, wxMODERN, wxNORMAL, wxNORMAL, 0, ""));
  // end wxGlade
}


void MyFrame::do_layout()
{
  // begin wxGlade: MyFrame::do_layout
  wxBoxSizer* sizer_1 = new wxBoxSizer(wxHORIZONTAL);
  wxBoxSizer* sizer_5_copy_1 = new wxBoxSizer(wxHORIZONTAL);
  wxBoxSizer* sizer_9_copy_1 = new wxBoxSizer(wxVERTICAL);
  wxStaticBoxSizer* sizer_11_copy_1 = new wxStaticBoxSizer(new wxStaticBox(ntbTree, -1, _("output")), wxHORIZONTAL);
  wxStaticBoxSizer* sizer_10_copy_1 = new wxStaticBoxSizer(new wxStaticBox(ntbTree, -1, _("input")), wxHORIZONTAL);
  wxBoxSizer* sizer_5_copy = new wxBoxSizer(wxHORIZONTAL);
  wxBoxSizer* sizer_9_copy = new wxBoxSizer(wxVERTICAL);
  wxStaticBoxSizer* sizer_11_copy = new wxStaticBoxSizer(new wxStaticBox(ntbDetect, -1, _("output")), wxHORIZONTAL);
  wxStaticBoxSizer* sizer_10_copy = new wxStaticBoxSizer(new wxStaticBox(ntbDetect, -1, _("input")), wxHORIZONTAL);
  wxBoxSizer* sizer_5 = new wxBoxSizer(wxHORIZONTAL);
  wxBoxSizer* sizer_9 = new wxBoxSizer(wxVERTICAL);
  wxStaticBoxSizer* sizer_11 = new wxStaticBoxSizer(new wxStaticBox(ntbTrans, -1, _("output")), wxHORIZONTAL);
  wxBoxSizer* sizer_12 = new wxBoxSizer(wxVERTICAL);
  wxStaticBoxSizer* sizer_10 = new wxStaticBoxSizer(new wxStaticBox(ntbTrans, -1, _("input")), wxHORIZONTAL);
  sizer_10->Add(txtTransInput, 1, wxEXPAND, 0);
  sizer_10->Add(5, 5, 0, 0, 0);
  sizer_9->Add(sizer_10, 1, wxEXPAND, 0);
  sizer_11->Add(txtTransOutput, 1, wxEXPAND, 0);
  sizer_11->Add(5, 5, 0, 0, 0);
  sizer_12->Add(5, 5, 0, 0, 0);
  sizer_12->Add(mHyperMarna, 0, 0, 0);
  sizer_12->Add(5, 5, 0, 0, 0);
  sizer_12->Add(mHyperRNA, 0, 0, 0);
  sizer_11->Add(sizer_12, 0, wxEXPAND, 0);
  sizer_9->Add(sizer_11, 1, wxEXPAND, 0);
  sizer_5->Add(sizer_9, 1, wxEXPAND, 0);
  ntbTrans->SetAutoLayout(true);
  ntbTrans->SetSizer(sizer_5);
  sizer_5->Fit(ntbTrans);
  sizer_5->SetSizeHints(ntbTrans);
  sizer_10_copy->Add(txtDetectInput, 1, wxEXPAND, 0);
  sizer_10_copy->Add(5, 5, 0, 0, 0);
  sizer_9_copy->Add(sizer_10_copy, 1, wxEXPAND, 0);
  sizer_11_copy->Add(txtDetectOutput, 1, wxEXPAND, 0);
  sizer_11_copy->Add(5, 5, 0, 0, 0);
  sizer_9_copy->Add(sizer_11_copy, 1, wxEXPAND, 0);
  sizer_5_copy->Add(sizer_9_copy, 1, wxEXPAND, 0);
  ntbDetect->SetAutoLayout(true);
  ntbDetect->SetSizer(sizer_5_copy);
  sizer_5_copy->Fit(ntbDetect);
  sizer_5_copy->SetSizeHints(ntbDetect);
  sizer_10_copy_1->Add(txtTreeInput, 1, wxEXPAND, 0);
  sizer_10_copy_1->Add(5, 5, 0, 0, 0);
  sizer_9_copy_1->Add(sizer_10_copy_1, 1, wxEXPAND, 0);
  sizer_11_copy_1->Add(txtTreeOutput, 1, wxEXPAND, 0);
  sizer_11_copy_1->Add(5, 5, 0, 0, 0);
  sizer_9_copy_1->Add(sizer_11_copy_1, 1, wxEXPAND, 0);
  sizer_5_copy_1->Add(sizer_9_copy_1, 1, wxEXPAND, 0);
  ntbTree->SetAutoLayout(true);
  ntbTree->SetSizer(sizer_5_copy_1);
  sizer_5_copy_1->Fit(ntbTree);
  sizer_5_copy_1->SetSizeHints(ntbTree);
  ntbAll->AddPage(ntbTrans, _("ctTransform"));
  ntbAll->AddPage(ntbDetect, _("cbcDetect"));
  ntbAll->AddPage(ntbTree, _("cbcTree"));
#if wxMAJOR_VERSION >= 2 && wxMINOR_VERSION > 4
  sizer_1->Add(ntbAll, 1, wxEXPAND, 0);
#else
  sizer_1->Add(new wxNotebookSizer(ntbAll), 1, wxEXPAND, 0);
#endif
  SetAutoLayout(true);
  SetSizer(sizer_1);
  Layout();
  Centre();
  // end wxGlade
}


MyDialogPref::MyDialogPref( wxWindow * parent, int id, const wxString & title, const wxPoint & pos, const wxSize & size,
    long style ) : wxDialog( parent, id, title, pos, size, wxDEFAULT_DIALOG_STYLE )
{

  help.UseConfig( wxConfig::Get() );
  bool ret;
#ifndef DARWIN_SYSTEM
  help.SetTempDir( wxT( "." ) ); // wxT ??
  ret = help.AddBook( wxFileName( wxString( (MyApp::get_help_path() + "/help.hhp").c_str() ), wxPATH_UNIX ) );
  if ( !ret )
    wxMessageBox( wxString( ("Failed adding book " +  MyApp::get_help_path() +  "/help.hhp").c_str() ) );
#endif

  // Set up toolbar
  wxBitmap toolBarBitmaps[1];
  toolBarBitmaps[0] = wxBitmap( open_xpm );

  // begin wxGlade: MyDialogPref::MyDialogPref
  rdoTree1 = new wxRadioButton(this, idRdoTree1, _("Tree Viewer 1"));
  txtPrefTreeViewer1 = new wxTextCtrl(this, -1, wxT(""));
  btnPrefOpenTreeViewer1 = new wxBitmapButton(this, idBtnPrefOpenTreeViewer1, (toolBarBitmaps[0]));
  rdoTree2 = new wxRadioButton(this, idRdoTree2, _("Tree Viewer 2"));
  txtPrefTreeViewer2 = new wxTextCtrl(this, -1, wxT(""));
#ifdef UNIX_SYSTEM
  txtPrefBrowser = new wxTextCtrl( this, -1, "");
  btnPrefOpenBrowser = new wxBitmapButton(this, idBtnPrefOpenBrowser, (toolBarBitmaps[0]));
#endif
  btnPrefOpenTreeViewer2 = new wxBitmapButton(this, idBtnPrefOpenTreeViewer2, (toolBarBitmaps[0]));
  rdoPrefNoneTree = new wxRadioButton(this, idRdoPrefNone, _("None"));
  btnOk = new wxButton(this, idBtnPrefOk, _("Ok"));
  btnCancel = new wxButton(this, idBtnPrefCancel, _("Cancel"));
#ifndef DARWIN_SYSTEM
  btnHelp = new wxButton(this, idBtnPrefHelp, _("Help"));
#endif

  set_properties();
  do_layout();
  // end wxGlade
}


void MyDialogPref::set_properties()
{
  // begin wxGlade: MyDialogPref::set_properties
  SetTitle(_("Preferences"));
  txtPrefTreeViewer1->SetSize(wxSize(400, -1));
  btnPrefOpenTreeViewer1->SetSize(wxSize(23, 23));
  txtPrefTreeViewer2->SetSize(wxSize(400, -1));
  btnPrefOpenTreeViewer2->SetSize(wxSize(23, 23));
#ifdef UNIX_SYSTEM
  txtPrefBrowser->SetSize(wxSize(400, -1));
  btnPrefOpenBrowser->SetSize(wxSize(23, 23));
#endif 
  btnOk->SetDefault();
  // end wxGlade
}


void MyDialogPref::do_layout()
{
  // begin wxGlade: MyDialogPref::do_layout
  wxBoxSizer* sizer_16 = new wxBoxSizer(wxHORIZONTAL);
  wxBoxSizer* sizer_8_copy_copy = new wxBoxSizer(wxVERTICAL);
  wxBoxSizer* sizerButtons = new wxBoxSizer(wxHORIZONTAL);
  wxStaticBoxSizer* szPrefTreeViewer = new wxStaticBoxSizer(new wxStaticBox(this, -1, _("Tree Viewer")), wxHORIZONTAL);
  wxFlexGridSizer* grid_sizer_3 = new wxFlexGridSizer(6, 3, 5, 5);
  sizer_16->Add(5, 5, 0, 0, 0);
  sizer_8_copy_copy->Add(5, 5, 0, 0, 0);
  grid_sizer_3->Add(rdoTree1, 0, wxALIGN_CENTER_VERTICAL, 0);
  grid_sizer_3->Add(txtPrefTreeViewer1, 0, 0, 0);
  grid_sizer_3->Add(btnPrefOpenTreeViewer1, 0, 0, 0);
  grid_sizer_3->Add(rdoTree2, 0, wxALIGN_CENTER_VERTICAL, 0);
  grid_sizer_3->Add(txtPrefTreeViewer2, 0, 0, 0);
  grid_sizer_3->Add(btnPrefOpenTreeViewer2, 0, 0, 0);
  grid_sizer_3->Add(rdoPrefNoneTree, 0, wxALIGN_CENTER_VERTICAL, 0);
  grid_sizer_3->Add(5, 5, 0, 0, 0);
  grid_sizer_3->Add(23, 23, 0, 0, 0);
#ifdef UNIX_SYSTEM
  grid_sizer_3->Add(new wxStaticText(this, -1, _("Browser:"), wxDefaultPosition, wxDefaultSize, wxALIGN_CENTRE), 0, wxALIGN_CENTER_VERTICAL, 0);
  grid_sizer_3->Add(txtPrefBrowser, 0, 0, 0);
  grid_sizer_3->Add(btnPrefOpenBrowser, 0, 0, 0);
#endif 
  szPrefTreeViewer->Add(grid_sizer_3, 0, wxEXPAND, 0);
  szPrefTreeViewer->Add(5, 5, 0, 0, 0);
  sizer_8_copy_copy->Add(szPrefTreeViewer, 0, wxEXPAND, 0);
  sizer_8_copy_copy->Add(5, 5, 0, 0, 0);
  sizer_8_copy_copy->Add(5, 5, 0, 0, 0);
  sizerButtons->Add(btnOk, 0, 0, 0);
  sizerButtons->Add(20, 20, 0, 0, 0);
  sizerButtons->Add(btnCancel, 0, 0, 0);
#ifndef DARWIN_SYSTEM
  sizerButtons->Add(20, 20, 0, 0, 0);
  sizerButtons->Add(btnHelp, 0, 0, 0);
#endif
  sizer_8_copy_copy->Add(sizerButtons, 0, wxALIGN_RIGHT, 0);
  sizer_8_copy_copy->Add(5, 5, 0, 0, 0);
  sizer_16->Add(sizer_8_copy_copy, 1, wxEXPAND, 0);
  sizer_16->Add(5, 5, 0, 0, 0);
  SetAutoLayout(true);
  SetSizer(sizer_16);
  sizer_16->Fit(this);
  sizer_16->SetSizeHints(this);
  Layout();
  // end wxGlade
}

IMPLEMENT_APP( MyApp )

#ifndef WINDOWS_SYSTEM
void my_terminate() 
{
  std::cout << "terminate called :( logging backtrace..." << std::endl;
  std::ostringstream pid_str; 
  pid_str << getpid();
  std::string pid = pid_str.str();
  pid_t gdb_pid;
  if (0 == (gdb_pid = fork())) {
    {
      std::ofstream out("cbc_analyser.cmd", std::ios::trunc);
      out << "set language c++\nbt\nquit\n";
      out.close();
    }
    int log = open("terminate.log", O_RDWR | O_CREAT);
    fchmod( log, S_IRUSR | S_IWUSR );
    lseek(log, 0, SEEK_END);
    dup2(log, 1);

    std::time_t now = std::time(0);
    std::cout << "\n\n----- sudden death at " << std::ctime(&now);
    execlp("gdb", "gdb", "-quiet", "-x", "cbc_analyser.cmd", "cbcanalyser", pid.c_str(), 0);
    std::cout << "install gdb in your path if you want to have real log files!" << std::endl;
    close( log );
    std::exit(127);
  }
  waitpid(gdb_pid, 0, 0);
  std::remove("cbc_analyser.cmd");
  wxMessageBox( _T("Dear beta tester of cbcanalyser,\n"
        "This software still needs a lot of work. So please send\n"
        "the contents of terminate.log, which should be found in\n"
        "the working directory e.g. your home directory, to the\n"
        "current maintainer:\n"
        "cbcanalyser@biozentrum.uni-wuerzburg.de/\n" ), 
      _T( "Program Termination" ), // caption
      wxOK );
}
#endif

MyApp::MyApp()
{
#ifdef DARWIN_SYSTEM
  help_path = "profdist.app/Resources/help/"; 
  examples_path = "profdist.app/Resources/";
#elif WINDOWS_SYSTEM
  help_path = "help/";
  examples_path = "examples/";
#else 
  // TODO 
  help_path = CBCANALYSER_SHARE"help/";
  examples_path = CBCANALYSER_SHARE;
#endif
}


std::string MyApp::examples_path;
std::string MyApp::help_path;
std::string const& MyApp::get_help_path() { return help_path;}
std::string const& MyApp::get_examples_path() { return examples_path;}

#ifdef DARWIN_SYSTEM
OSStatus RegisterMyHelpBook(void);
#endif 

bool MyApp::OnInit()
{

#ifndef WINDOWS_SYSTEM
  std::unexpected_handler a = std::set_terminate( my_terminate );
#endif

#ifdef DARWIN_SYSTEM
  RegisterMyHelpBook(); 
#endif

  
  wxInitAllImageHandlers();
  MyFrame * mainFrame = new MyFrame( 0, -1, "" );

  if ( !mainFrame->loadXmlFile() )
  {
    wxMessageDialog dialog( mainFrame, "XML File not found!", _T( "Error!" ), wxICON_ERROR );
    dialog.ShowModal();
    return false;
  }
  mainFrame->setSelection();
  SetTopWindow( mainFrame );
  mainFrame->Show();

  return true;
}

#ifdef DARWIN_SYSTEM
OSStatus RegisterMyHelpBook(void) {
    CFBundleRef myAppsBundle;
    CFURLRef myBundleURL;
    FSRef myBundleRef;
    OSStatus err;

        /* set up a known state */
    myAppsBundle = NULL;
    myBundleURL = NULL;

        /* Get our application's main bundle
        from Core Foundation */
    myAppsBundle = CFBundleGetMainBundle();
    if (myAppsBundle == NULL) { err = fnfErr; goto bail;}

        /* retrieve the URL to our bundle */
    myBundleURL = CFBundleCopyBundleURL(myAppsBundle);
    if (myBundleURL == nil) { err = fnfErr; goto bail;}

        /* convert the URL to a FSRef */
    if ( ! CFURLGetFSRef(myBundleURL, &myBundleRef) ) {
        err = fnfErr;
        goto bail;
    }

        /* register our application's help book */
    err = AHRegisterHelpBook(&myBundleRef);
    if (err != noErr) goto bail;

        /* done */
    CFRelease(myBundleURL);
    return noErr;

bail:
    if (myBundleURL != NULL) CFRelease(myBundleURL);
    return err;
}
#endif



MyDialogAbout::MyDialogAbout( wxWindow * parent, int id, const wxString & title, const wxPoint & pos, const wxSize & size,
    long style ) : wxDialog( parent, id, title, pos, size, wxDEFAULT_DIALOG_STYLE )
{
  // Set up toolbar
  wxBitmap aboutBitmaps[1];
  aboutBitmaps[0] = wxBitmap( about_xpm );

  // begin wxGlade: MyDialogAbout::MyDialogAbout
  bitmap_1 = new wxStaticBitmap(this, -1, (aboutBitmaps[0]));
  label_5 = new wxStaticText(this, -1, (std::string("Version " PACKAGE_VERSION " on C++ with boost-" BOOST_LIB_VERSION " and\n") + std::string(wxVERSION_STRING)).c_str(), wxDefaultPosition, wxDefaultSize, wxALIGN_LEFT);
  mHyperWx = new wxHyperlinksCtrl(this, idLinkWx, "http://www.wxwidgets.org", wxPoint(70,30), wxDefaultSize, 0, "statictextlink2", "http://www.wxwidgets.org");
  mHyperBoost = new wxHyperlinksCtrl(this, idLinkBoost, "http://www.boost.org", wxPoint(70,30), wxDefaultSize, 0, "statictextlink3", "http://www.boost.org");
  mHyperCbc = new wxHyperlinksCtrl(this, idLinkCbc, "CBCAnalyzer", wxPoint(70,30), wxDefaultSize, 0, "statictextlink3", "http://cbcanalyzer.bioapps.biozentrum.uni-wuerzburg.de/");


  set_properties();
  do_layout();
  // end wxGlade
}


void MyDialogAbout::set_properties()
{
  // begin wxGlade: MyDialogAbout::set_properties
  SetTitle(_("About cbcAnalyzer"));
  // end wxGlade
}


void MyDialogAbout::do_layout()
{
  // begin wxGlade: MyDialogAbout::do_layout
  wxBoxSizer* sizer_31 = new wxBoxSizer(wxHORIZONTAL);
  wxBoxSizer* sizer_32 = new wxBoxSizer(wxVERTICAL);
  sizer_31->Add(5, 5, 0, 0, 0);
  sizer_32->Add(5, 5, 0, 0, 0);
  sizer_32->Add(bitmap_1, 0, 0, 0);
  sizer_32->Add(5, 5, 0, 0, 0);
  sizer_32->Add(label_5, 0, 0, 0);
  sizer_32->Add(5, 5, 0, 0, 0);
  sizer_32->Add(mHyperWx, 1, wxEXPAND, 0);
  sizer_32->Add(5, 5, 0, 0, 0);
  sizer_32->Add(mHyperBoost, 1, wxEXPAND, 0);
  sizer_32->Add(5, 5, 0, 0, 0);
  sizer_32->Add(mHyperCbc, 1, wxEXPAND, 0);
  sizer_32->Add(5, 5, 0, 0, 0);
  sizer_31->Add(sizer_32, 1, wxEXPAND, 0);
  sizer_31->Add(5, 5, 0, 0, 0);
  SetAutoLayout(true);
  SetSizer(sizer_31);
  sizer_31->Fit(this);
  sizer_31->SetSizeHints(this);
  Layout();
  // end wxGlade
}



