/***************************************************************************
 *   Copyright (C) 2005 by Andreas Pokorny                                 *
 *   andreas.pokorny@biozentrum.uni-wuerzburg.de                           *
 *                                                                         *
 *   This file is part of profdist and cbcanalyzer                         *
 *                                                                         *
 *   Both profdist and cbcanalyzer are free software  you can redistribute * 
 *   it and/or modify it under the terms of the GNU General Public License * 
 *   as published by the Free Software Foundation  either version 2 of the * 
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   Profdist and cbcanalyzer are distributed in the hope that it will be  *
 *   useful, but WITHOUT ANY WARRANTY  without even the implied warranty   *
 *   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program  if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/**
 * transfroms ct files to fasta format with fold info
 * @param[in] filename
 * @param[in] output stream
 */
void transform( std::string const& filename, std::ostream & out );

/**
 * detects cbc, and creates a distance matrix based on that information.
 * @param[in] filename 
 * @param[out] matrix 
 * @param[out] names
 */
void detect( std::string const& filename, distance_matrix & matrix, vector<string> & names );


/**
 * Just runs bionj on distance matrix, and writes tree into the target file 
 * @param[in] names
 * @param[in] distances
 * @param[in] out target file 
 */
void generate_tree( std::vector<string> const& names, distance_matrix const& distances, std::ostream & out )


