/***************************************************************************
 *   Copyright (C) 2005 by Andreas Pokorny                                 *
 *   andreas.pokorny@biozentrum.uni-wuerzburg.de                           *
 *                                                                         *
 *   This file is part of profdist and cbcanalyzer                         *
 *                                                                         *
 *   Both profdist and cbcanalyzer are free software; you can redistribute * 
 *   it and/or modify it under the terms of the GNU General Public License * 
 *   as published by the Free Software Foundation; either version 2 of the * 
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   Profdist and cbcanalyzer are distributed in the hope that it will be  *
 *   useful, but WITHOUT ANY WARRANTY; without even the implied warranty   *
 *   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef PROFDIST_PARSED_TREE_H_INCLUDED
#define PROFDIST_PARSED_TREE_H_INCLUDED
#include <boost/shared_ptr.hpp>
#include <string>
#include <list>
#include <vector>
#include <iostream>

namespace profdist {
  
struct parsed_node {
  typedef boost::shared_ptr<parsed_node> node_ptr; 
  std::list<node_ptr> childs;
  std::size_t sequence_id; 
  std::string extra_data;
  parsed_node(): sequence_id(0) {}
  inline bool is_leaf() const {return childs.empty();}
  inline std::string const& get_extra_data() const {return extra_data;}
  inline std::size_t get_sequence_id() const { return sequence_id; }
  void print( std::ostream & out, std::vector<std::string> const& names ) const;
  void print_tree( std::ostream & out, std::vector<std::string> const& names ) const;
};

}

#endif

