/***************************************************************************
 *   Copyright (C) 2005 by Andreas Pokorny                                 *
 *   andreas.pokorny@biozentrum.uni-wuerzburg.de                           *
 *                                                                         *
 *   This file is part of profdist and cbcanalyzer                         *
 *                                                                         *
 *   Both profdist and cbcanalyzer are free software; you can redistribute * 
 *   it and/or modify it under the terms of the GNU General Public License * 
 *   as published by the Free Software Foundation; either version 2 of the * 
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   Profdist and cbcanalyzer are distributed in the hope that it will be  *
 *   useful, but WITHOUT ANY WARRANTY; without even the implied warranty   *
 *   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <cstring>
#include "dnamapper.h"

DNAMapper::DNAMapper()
{
  std::memset( dna2code, 0, 128);
  std::memset( code2dna, 0, 128);
  dna2code[0] = 0;
  dna2code[1] = 1;
  dna2code[2] = 2;
  dna2code[3] = 3;
  dna2code[4] = 4;
  dna2code[5] = 5;
  dna2code[6] = 6;
  dna2code[7] = 7;
  dna2code[8] = 8;
  dna2code[9] = 9;
  dna2code[10] = 10;
  dna2code[11] = 11;
  dna2code[12] = 12;
  dna2code[13] = 13;
  dna2code[14] = 14;
  dna2code[15] = 15;

  dna2code['A'] = 0;
  dna2code['a'] = 0;
  dna2code['C'] = 1;
  dna2code['c'] = 1;
  dna2code['G'] = 2;
  dna2code['g'] = 2;
  dna2code['U'] = 3;
  dna2code['u'] = 3;
  dna2code['T'] = 3;
  dna2code['t'] = 3;
  dna2code['N'] = 5;
  dna2code['n'] = 5;
  dna2code['O'] = 5;
  dna2code['o'] = 5;
  
  dna2code['-'] = 4;
  dna2code['V'] = 6;
  dna2code['v'] = 6;
  dna2code['H'] = 7;
  dna2code['h'] = 7;
  dna2code['M'] = 8;
  dna2code['m'] = 8;
  dna2code['R'] = 9;
  dna2code['r'] = 9;
  dna2code['D'] = 10;
  dna2code['d'] = 10;
  dna2code['W'] = 11;
  dna2code['w'] = 11;
  dna2code['S'] = 12;
  dna2code['s'] = 12;
  dna2code['B'] = 13;
  dna2code['b'] = 13;
  dna2code['Y'] = 14;
  dna2code['y'] = 14;
  dna2code['K'] = 15;
  dna2code['k'] = 15;

  code2dna[0] = 'A';
  code2dna[1] = 'C';
  code2dna[2] = 'G';
  code2dna[3] = 'T';
  code2dna[4] = '-';
  code2dna[5] = 'N';
  code2dna[6] = 'V';
  code2dna[7] = 'H';
  code2dna[8] = 'M';
  code2dna[9] = 'R';
  code2dna[10] = 'D';
  code2dna[11] = 'W';
  code2dna[12] = 'S';
  code2dna[13] = 'B';
  code2dna[14] = 'Y';
  code2dna[15] = 'K';

  code2dna['A'] ='A';
  code2dna['a'] ='a';
  code2dna['C'] ='C';
  code2dna['c'] ='c';
  code2dna['G'] ='G';
  code2dna['g'] ='g';
  code2dna['U'] ='U';
  code2dna['u'] ='u';
  code2dna['T'] ='T';
  code2dna['t'] ='t';
  code2dna['N'] ='N';
  code2dna['n'] ='n';
  code2dna['O'] ='O';
  code2dna['o'] ='o';

  code2dna['-'] ='-';
  code2dna['V'] ='V';
  code2dna['v'] ='v';
  code2dna['H'] ='H';
  code2dna['h'] ='h';
  code2dna['M'] ='M';
  code2dna['m'] ='m';
  code2dna['R'] ='R';
  code2dna['r'] ='r';
  code2dna['D'] ='D';
  code2dna['d'] ='d';
  code2dna['W'] ='W';
  code2dna['w'] ='w';
  code2dna['S'] ='S';
  code2dna['s'] ='s';
  code2dna['B'] ='B';
  code2dna['b'] ='b';
  code2dna['Y'] ='Y';
  code2dna['y'] ='y';
  code2dna['K'] ='K';
  code2dna['k'] ='k';
}

DNAMapper& get_mapper_instance()
{
  static DNAMapper instance;
  return instance;
}


