/***************************************************************************
 *   Copyright (C) 2005 by Andreas Pokorny                                 *
 *   andreas.pokorny@biozentrum.uni-wuerzburg.de                           *
 *                                                                         *
 *   This file is part of profdist and cbcanalyzer                         *
 *                                                                         *
 *   Both profdist and cbcanalyzer are free software; you can redistribute * 
 *   it and/or modify it under the terms of the GNU General Public License * 
 *   as published by the Free Software Foundation; either version 2 of the * 
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   Profdist and cbcanalyzer are distributed in the hope that it will be  *
 *   useful, but WITHOUT ANY WARRANTY; without even the implied warranty   *
 *   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "cbcs.h"
#include <cctype>
/* Broken detector! 
namespace {
inline std::size_t fun(int const& a, int const& b )
{ return a*a + b*b; }
}
std::size_t CbcDetector::operator()( char seq1_base1, char seq1_base2, char seq2_base1, char seq2_base2 ) const
{
  std::size_t f = fun( std::tolower(seq1_base1), std::tolower(seq1_base2) ); 
  std::size_t s = fun( std::tolower(seq2_base1), std::tolower(seq2_base2) );
  const std::size_t cbc1 = 'a'*'a' + 'u'*'u';
  const std::size_t cbc2 = 'g'*'g' + 'c'*'c';
  const std::size_t cbc3 = 'g'*'g' + 'u'*'u';
  return ( f == cbc1 || f == cbc2 ) 
      && ( s == cbc1 || s == cbc2 );
}
*/

CbcDetector::CbcDetector()
{
#define INS(A,B,C,D) cbc_info.insert(f_pair(c_pair(A,B),c_pair(C,D)));
    INS('A','U','U','A');
    INS('A','U','C','G');
    INS('A','U','G','C');
    INS('G','U','U','A');
    INS('G','U','C','G');
    INS('G','U','U','G');
    INS('G','C','A','U');
    INS('G','C','U','A');
    INS('G','C','C','G');
    INS('U','A','A','U');
    INS('U','A','G','C');
    INS('U','A','C','G');
    INS('C','G','U','A');
    INS('C','G','A','U');
    INS('C','G','G','C');
    INS('U','G','A','U');
    INS('U','G','G','C');
    INS('U','G','G','U');

    //INS('A','U','G','U');
    //INS('G','U','A','U');
    //INS('G','U','G','C');
    //INS('G','C','G','U');
    //INS('U','A','U','G');
    //INS('C','G','U','G');
    //INS('U','G','U','A');
    //INS('U','G','C','G');
#undef INS
}

namespace { 
  inline char T2U( char v )
  {
    return v == 'T'?'U':v;
  }
}

std::size_t CbcDetector::operator()( char seq1_base1, char seq1_base2, char seq2_base1, char seq2_base2 ) const
{
  return cbc_info.find(
      f_pair(
        c_pair(
          T2U( std::toupper(seq1_base1) )
          , T2U( std::toupper(seq1_base2) )
          )
        , c_pair(
          T2U( std::toupper(seq2_base1) )
          , T2U( std::toupper(seq2_base2) )
          )
        )
      )
    != cbc_info.end();
}

