/***************************************************************************
 *   Copyright (C) 2005 by Andreas Pokorny                                 *
 *   andreas.pokorny@biozentrum.uni-wuerzburg.de                           *
 *                                                                         *
 *   This file is part of profdist and cbcanalyzer                         *
 *                                                                         *
 *   Both profdist and cbcanalyzer are free software; you can redistribute * 
 *   it and/or modify it under the terms of the GNU General Public License * 
 *   as published by the Free Software Foundation; either version 2 of the * 
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   Profdist and cbcanalyzer are distributed in the hope that it will be  *
 *   useful, but WITHOUT ANY WARRANTY; without even the implied warranty   *
 *   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef PROFDIST_BOOTSTRAP_H_INCLUDED
#define PROFDIST_BOOTSTRAP_H_INCLUDED

#include "aligncode.h"
#include "profile.h"

/**
 * @brief generates a bootstrap from source in destination
 * @param source Alignment source, is not modified by that function
 * @param destination the destination, 
 * @param extension defines a suffix for the sequence names of the destination object, 
 * Bootstraps other alignments from a source alignment 
 * by random picking of sequence entries with put back.
*/
void bootstrap( AlignCode const& source, AlignCode & destination, std::string const& extension ="" );

/**
 * @brief generates a bootstrap from source in destination
 * @param source profile source, is not modified by that function
 * @param destination the destination, 
 * Bootstraps other alignments from a source alignment 
 * by random picking of sequence entries with put back.
*/
void bootstrap( Profile const& source, Profile & destination );

#endif

