/***************************************************************************
 *   Copyright (C) 2005 by Andreas Pokorny                                 *
 *   andreas.pokorny@biozentrum.uni-wuerzburg.de                           *
 *                                                                         *
 *   This file is part of profdist and cbcanalyzer                         *
 *                                                                         *
 *   Both profdist and cbcanalyzer are free software; you can redistribute * 
 *   it and/or modify it under the terms of the GNU General Public License * 
 *   as published by the Free Software Foundation; either version 2 of the * 
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   Profdist and cbcanalyzer are distributed in the hope that it will be  *
 *   useful, but WITHOUT ANY WARRANTY; without even the implied warranty   *
 *   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef BIOAPPS_WX_COLOR_BUF_INCLUDED
#define BIOAPPS_WX_COLOR_BUF_INCLUDED

#include <wx/wx.h>
#include <iostream>
/**
 * Unclean and restricted implementation of a streambuf that forwards to 
 * the terribly designed wxTextCtrl (Ctrl does not stand for Control in this context). 
 */
class wx_colour_streambuf : public std::streambuf
{
  private:
    wxTextCtrl & ref;
    char array[4096];
  public:
    wx_colour_streambuf( wxTextCtrl & ref );
    ~wx_colour_streambuf();
  protected:

    int overflow( int c );
    int sync( );
};

#endif

