/***************************************************************************
 *   Copyright (C) 2005 by Joachim Friedrich                               *
 *   joachim.friedrich@biozentrum.uni-wuerzburg.de                         *
 *                                                                         *
 *   This file is part of profdist and cbcanalyzer                         *
 *                                                                         *
 *   Both profdist and cbcanalyzer are free software; you can redistribute * 
 *   it and/or modify it under the terms of the GNU General Public License * 
 *   as published by the Free Software Foundation; either version 2 of the * 
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   Profdist and cbcanalyzer are distributed in the hope that it will be  *
 *   useful, but WITHOUT ANY WARRANTY; without even the implied warranty   *
 *   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

// -*- C++ -*- generated by wxGlade 0.3.2 on Tue Jul 06 19:02:41 2004

//---------------------------------------------------------------------------
// INCLUDES
//---------------------------------------------------------------------------

// begin wxGlade: ::dependencies
#include <wx/notebook.h>
// end wxGlade

#include <wx/wx.h>
#include <wx/image.h>
#include <wx/txtstrm.h>
#include <wx/utils.h>
//#include <wx/file.h>
#include <wx/filename.h>

// Included for help
#include <wx/html/helpfrm.h>
#include <wx/html/helpctrl.h>
#include <wx/filesys.h>
#include <wx/fs_zip.h>

// Included for hyperlinks
#include "wxHyperlinksCtrl.h"

#include <queue>
#include <iostream>
#include <string>
#include <vector>
#include <fstream>
#include <stack>
#include <map>


#ifdef HAVE_CONFIG_H
#include <config.h>
#define CBCANALYSER_SHARE DATADIR "/cbcanalyzer/"
#else
#define CBCANALYSER_SHARE 
#endif 
//#include <stdlib>

//#include "tMatrix.h"
//#include "bionj.h"

//---------------------------------------------------------------------------
// DEFINES, MAKROS
//---------------------------------------------------------------------------
#if !defined(CBCANALYSER_H)
  #define CBCANALYSER_H

  #define USE_XPM_BITMAPS 1
  #ifdef __WXMSW__
    #define wxUSE_XPM_IN_MSW 1
  #endif

  #if USE_XPM_BITMAPS && defined(__WXMSW__) && !wxUSE_XPM_IN_MSW
    #error You need to enable XPM support to use XPM bitmaps with toolbar!
  #endif // USE_XPM_BITMAPS

  #include "icons/open.xpm"
  #include "icons/about.xpm"
  #include "icons/save.xpm"
  #include "icons/redo.xpm"
  #include "icons/undo.xpm"
  #include "icons/copy.xpm"
  #include "icons/cut.xpm"
  #include "icons/paste.xpm"
  #include "icons/run.xpm"
  #include "icons/tree.xpm"
  #include "icons/pref.xpm"
  #include "icons/help.xpm"
  #include "icons/starlight.xpm"


class MyDialogAbout : public wxDialog
{
public:
    // begin wxGlade: MyDialogAbout::ids
    // end wxGlade

  MyDialogAbout( wxWindow * parent, int id, const wxString & title, const wxPoint & pos = wxDefaultPosition,
       const wxSize & size = wxDefaultSize, long style = wxDEFAULT_DIALOG_STYLE );

private:
    // begin wxGlade: MyDialogAbout::methods
    void set_properties();
    void do_layout();
    // end wxGlade

  void onLinkWx( wxHyperlinkEvent & event );
  void onLinkCbc( wxHyperlinkEvent & event );
  void onLinkBoost( wxHyperlinkEvent & event );

  DECLARE_EVENT_TABLE()


  protected :
    // begin wxGlade: MyDialogAbout::attributes
    wxStaticBitmap* bitmap_1;
    wxStaticText* label_5;
    wxHyperlinksCtrl* mHyperWx, * mHyperBoost, *mHyperCbc;
    // end wxGlade
};


class MyApp : public wxApp
{
  private:
    static std::string examples_path;
    static std::string help_path;
  public:
    MyApp();
    bool OnInit();
    static std::string const& get_help_path();
    static std::string const& get_examples_path();
};



class MyFrame : public wxFrame
{
public:
    // begin wxGlade: MyFrame::ids
    // end wxGlade

  MyFrame( wxWindow * parent, int id, const wxString & title, const wxPoint & pos = wxDefaultPosition, const wxSize & size =
       wxDefaultSize, long style = wxDEFAULT_FRAME_STYLE );

  void onNotebook( wxNotebookEvent & event );

  void onMnuOpen( wxCommandEvent & WXUNUSED( event ) );
  void onMnuSave( wxCommandEvent & WXUNUSED( event ) );
  void onMnuExit( wxCommandEvent & WXUNUSED( event ) );

  void onMnuUndo( wxCommandEvent & WXUNUSED( event ) );

  void onMnuCopy( wxCommandEvent & WXUNUSED( event ) );
  void onMnuPaste( wxCommandEvent & WXUNUSED( event ) );
  void onMnuCut( wxCommandEvent & WXUNUSED( event ) );
  void onMnuSelectAll( wxCommandEvent & WXUNUSED( event ) );

  void onMnuStart( wxCommandEvent & WXUNUSED( event ) );
  void onMnuTree( wxCommandEvent & WXUNUSED( event ) );
  void onMnuPref( wxCommandEvent & WXUNUSED( event ) );

  void onMnuHelp( wxCommandEvent & WXUNUSED( event ) );
  void onMnuAbout( wxCommandEvent & WXUNUSED( event ) );

  bool loadXmlFile();
  void saveXmlFile();
  void setSelection();

  void openFileTrans();
  void openFileDetect();
  void openFileTree();

  void startTrans();
  void startDetect();
  void startTree();

  void saveTrans();
  void saveDetect();
  void saveTree();

  bool doTrans();
  bool doDetect();
  bool doTree();

  void onCloseEvent( wxCloseEvent & WXUNUSED( event ));


private:
    // begin wxGlade: MyFrame::methods
    void set_properties();
    void do_layout();
    // end wxGlade
  wxTextCtrl * getFocusedText();

  wxHtmlHelpController help;

  DECLARE_EVENT_TABLE()

  protected :
    // begin wxGlade: MyFrame::attributes
    wxMenuBar* frame_1_menubar;
    wxStatusBar* frame_1_statusbar;
    wxToolBar* frame_toolbar;
    wxTextCtrl* txtTransInput;
    wxTextCtrl* txtTransOutput;
    wxHyperlinksCtrl* mHyperMarna;
    wxHyperlinksCtrl* mHyperRNA;
    wxScrolledWindow* ntbTrans;
    wxTextCtrl* txtDetectInput;
    wxTextCtrl* txtDetectOutput;
    wxPanel* ntbDetect;
    wxTextCtrl* txtTreeInput;
    wxTextCtrl* txtTreeOutput;
    wxPanel* ntbTree;
    wxNotebook* ntbAll;
    // end wxGlade

  // -------------------------------------------------------------------------
  // Functions
  // -------------------------------------------------------------------------
  void display_file( wxString const& tempfile );

  // -------------------------------------------------------------------------
  // Member Variables
  // -------------------------------------------------------------------------
  long mEvoModel;
  long mTreeViewType;
  wxString mFileTreeViewer1;
  wxString mFileTreeViewer2;
#if defined(UNIX_SYSTEM) || defined(DARWIN_SYSTEM)
  wxString mFileBrowser;
#endif

  long mNtbSelection;
  long mRdoDetectInput;

  std::queue < wxString > mFileQueue; // queue for temporary created files

  // File Path
  wxString mTransFilePath;
  wxString mDetectFilePath;
  wxString mTreeFilePath;

 // std::map < wxString, int > mMapCBC;
 // map < wxString, int > mMapPair;
};



class MyDialogPref : public wxDialog
{
public:
    // begin wxGlade: MyDialogPref::ids
    // end wxGlade

  MyDialogPref( wxWindow * parent, int id, const wxString & title, const wxPoint & pos = wxDefaultPosition,
       const wxSize & size = wxDefaultSize, long style = wxDEFAULT_DIALOG_STYLE );

#if defined(UNIX_SYSTEM) || defined(DARWIN_SYSTEM)
  void setPreferences( long & evoModel, long & treeViewType, wxString & treeView1, wxString & treeView2, wxString & browser );
  void getPreferences( long & evoModel, long & treeViewType, wxString & treeView1, wxString & treeView2, wxString & browser );
#else
  void setPreferences( long & evoModel, long & treeViewType, wxString & treeView1, wxString & treeView2 );
  void getPreferences( long & evoModel, long & treeViewType, wxString & treeView1, wxString & treeView2 );

#endif 

  void onBtnPrefOpenTreeViewer1( wxCommandEvent & WXUNUSED( event ) );
  void onBtnPrefOpenTreeViewer2( wxCommandEvent & WXUNUSED( event ) );
  void onBtnPrefOpenBrowser( wxCommandEvent & WXUNUSED( event ) );

  void onBtnPrefOk( wxCommandEvent & WXUNUSED( event ) );
  void onBtnPrefCancel( wxCommandEvent & WXUNUSED( event ) );
  void onBtnPrefHelp( wxCommandEvent & WXUNUSED( event ) );

  void onRdoTree1( wxCommandEvent & WXUNUSED( event ) );
  void onRdoTree2( wxCommandEvent & WXUNUSED( event ) );

  void onRdoPrefHypertree( wxCommandEvent & WXUNUSED( event ) );
  void onRdoPrefNone( wxCommandEvent & WXUNUSED( event ) );

private:
    // begin wxGlade: MyDialogPref::methods
    void set_properties();
    void do_layout();
    // end wxGlade

  wxHtmlHelpController help;

  DECLARE_EVENT_TABLE()

  protected :
    // begin wxGlade: MyDialogPref::attributes
    wxRadioButton* rdoTree1;
    wxTextCtrl* txtPrefTreeViewer1;
    wxBitmapButton* btnPrefOpenTreeViewer1;
    wxRadioButton* rdoTree2;
    wxTextCtrl* txtPrefTreeViewer2;
    wxBitmapButton* btnPrefOpenTreeViewer2;
    wxRadioButton* rdoPrefNoneTree;
    wxButton* btnOk;
    wxButton* btnCancel;
    wxButton* btnHelp;
    // end wxGlade
#if defined(UNIX_SYSTEM) || defined(DARWIN_SYSTEM)
    wxTextCtrl* txtPrefBrowser;
    wxBitmapButton* btnPrefOpenBrowser;
#endif

  long mPrefTreeType;
};


enum
{
  //MyFrame
       idMnuOpen, //
       idMnuSave, //
       idMnuExit, //
       idMnuUndo, //
       idMnuCopy, //
       idMnuCut, //
       idMnuPaste, //
       idMnuSelectAll, //
       idMnuPref, //
       idMnuStart, //
       idMnuTree, //
       idMnuHelp, //
       idMnuAbout, //

       idNotebook, //

       // MyDialogPref
       idBtnPrefOpenTreeViewer1, //
       idBtnPrefOpenTreeViewer2, //
       idBtnPrefOpenBrowser, //
       idBtnPrefOk, //
       idBtnPrefCancel, //
       idBtnPrefHelp, //
       idRdoTree1, //
       idRdoTree2, //
       idRdoPrefHypertree, //
       idRdoPrefNone, //
       idRdoPrefEvolution, //

       // MyDialogAbout
       idLinkWx, //
       idLinkCbc, //
       idLinkBoost, //
       idLinkMarna, //
       idLinkRNA //
};



#endif // CBCANALYSER_H

